/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.modem;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.modem.LocalModemCommandDetailPanel;
import DE.siemens.ad.logo.dialog.wizard.modem.RemoteModemCommandDetailPanel;
import DE.siemens.ad.logo.dialog.wizard.modem.SelectConfigModemModel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoModemSetting;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SelectConfigModemPanel
extends WizardInputPanel {
    private JTextArea fInfoText;
    private JCheckBox fLocalModemCheckBox;
    private JCheckBox fRemoteModemCheckBox;
    private JPanel generalModemPanel;
    private SelectConfigModemModel model;
    private JLabel fLocalModemLabel;
    private JLabel fRemoteModemLabel;
    private JButton fLocalModemButton;
    private JButton fRemoteModemButton;
    private String defaultLocalModem;
    private String defaultRemoteModem;

    public SelectConfigModemPanel(WizardPanelModel panelModel) {
        super(panelModel);
        this.model = (SelectConfigModemModel)panelModel;
        this.initialize();
        this.setDefaultValue();
    }

    private JCheckBox getRemoteModemCheckBox() {
        if (this.fRemoteModemCheckBox == null) {
            this.fRemoteModemCheckBox = new JCheckBox(Language.getString("wizard.modem.selectModemPanel.remoteModem", "Remote modem"));
        }
        return this.fRemoteModemCheckBox;
    }

    private JButton getRemoteModemButton() {
        if (this.fRemoteModemButton == null) {
            this.fRemoteModemButton = new JButton(Language.getString("wizard.modem.selectModemPanel.detail", "Detail..."));
            this.fRemoteModemButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    RemoteModemCommandDetailPanel panel = new RemoteModemCommandDetailPanel(SelectConfigModemPanel.this.defaultRemoteModem);
                    SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), panel, 1);
                    dialog.show();
                }
            });
        }
        return this.fRemoteModemButton;
    }

    private void initialize() {
        JLabel image = new JLabel(this.getIcon());
        this.fInfoText = new JTextArea(Language.getString("wizard.modem.selectModemPanel.infoText", "Select the modem you want to configure. If you have configured both of them, click \"Next\"."), 2, 38);
        this.fInfoText.setBackground(this.getBackground());
        this.fInfoText.setLineWrap(true);
        this.fInfoText.setWrapStyleWord(true);
        this.fInfoText.setEditable(false);
        this.fLocalModemLabel = new JLabel();
        this.fRemoteModemLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.fill = 2;
        constraint.anchor = 17;
        constraint.gridheight = 1;
        constraint.gridwidth = 2;
        constraint.gridx = 0;
        constraint.gridy = 0;
        this.add((Component)image, constraint);
        constraint.insets = new Insets(10, 10, 0, 0);
        constraint.gridx = 0;
        constraint.gridy = 1;
        this.add((Component)this.fInfoText, constraint);
        constraint.insets = new Insets(10, 0, 0, 0);
        constraint.gridx = 0;
        constraint.gridy = 2;
        constraint.gridheight = 2;
        constraint.gridwidth = 1;
        this.add((Component)this.getGeneralPanel(), constraint);
        constraint.gridx = 1;
        constraint.gridy = 2;
        constraint.weightx = 1.0;
        this.add((Component)new JPanel(), constraint);
        constraint.gridheight = 1;
        constraint.gridwidth = 2;
        constraint.gridx = 0;
        constraint.gridy = 4;
        constraint.weightx = 1.0;
        constraint.weighty = 1.0;
        this.add((Component)new JPanel(), constraint);
    }

    private JPanel getGeneralPanel() {
        if (this.generalModemPanel == null) {
            this.generalModemPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraint = new GridBagConstraints();
            constraint.fill = 2;
            constraint.anchor = 17;
            constraint.insets = new Insets(0, 10, 5, 0);
            constraint.gridx = 0;
            constraint.gridy = 0;
            this.generalModemPanel.add((Component)this.getRemoteModemCheckBox(), constraint);
            constraint.gridx = 1;
            constraint.gridy = 0;
            this.generalModemPanel.add((Component)this.fRemoteModemLabel, constraint);
            constraint.gridx = 2;
            constraint.gridy = 0;
            this.generalModemPanel.add((Component)this.getRemoteModemButton(), constraint);
            constraint.gridx = 0;
            constraint.gridy = 1;
            this.generalModemPanel.add((Component)this.getLocalModemCheckBox(), constraint);
            constraint.gridx = 1;
            constraint.gridy = 1;
            this.generalModemPanel.add((Component)this.fLocalModemLabel, constraint);
            constraint.gridx = 2;
            constraint.gridy = 1;
            this.generalModemPanel.add((Component)this.getLocalModemButton(), constraint);
        }
        return this.generalModemPanel;
    }

    private JCheckBox getLocalModemCheckBox() {
        if (this.fLocalModemCheckBox == null) {
            this.fLocalModemCheckBox = new JCheckBox(Language.getString("wizard.modem.selectModemPanel.localModem", "Local modem"));
        }
        return this.fLocalModemCheckBox;
    }

    private JButton getLocalModemButton() {
        if (this.fLocalModemButton == null) {
            this.fLocalModemButton = new JButton(Language.getString("wizard.modem.selectModemPanel.detail", "Detail..."));
            this.fLocalModemButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    LocalModemCommandDetailPanel panel = new LocalModemCommandDetailPanel(SelectConfigModemPanel.this.defaultLocalModem);
                    SplittedDlg dialog = SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), panel, 1);
                    dialog.show();
                }
            });
        }
        return this.fLocalModemButton;
    }

    public Icon getIcon() {
        return Global.getIcon("SelectModem.gif");
    }

    public void setLabels() {
        this.title = Language.getString("wizard.modem.selectModemPanel.title", "Select modem");
    }

    private void setDefaultValue() {
        LogoModemSetting setting = LogoModemSetting.getInstance();
        Hashtable defaultSetting = setting.getDefaultSettingName();
        this.defaultLocalModem = defaultSetting.get("DefaultLocal").toString();
        this.defaultRemoteModem = defaultSetting.get("DefaultRemote").toString();
        if (defaultSetting.get("DefaultLocal") != null && !defaultSetting.get("DefaultLocal").equals("")) {
            this.fLocalModemLabel.setText("<" + this.defaultLocalModem + ">");
            this.fLocalModemButton.setEnabled(true);
            this.fLocalModemCheckBox.setEnabled(true);
        } else {
            this.fLocalModemLabel.setText("");
            this.fLocalModemCheckBox.setSelected(true);
            this.fLocalModemCheckBox.setEnabled(false);
            this.fLocalModemButton.setEnabled(false);
        }
        if (defaultSetting.get("DefaultRemote") != null && !defaultSetting.get("DefaultRemote").equals("")) {
            this.fRemoteModemLabel.setText("<" + this.defaultRemoteModem + ">");
            this.fRemoteModemButton.setEnabled(true);
        } else {
            this.fRemoteModemLabel.setText("");
            this.fRemoteModemCheckBox.setSelected(true);
            this.fRemoteModemButton.setEnabled(false);
        }
        this.model.setLocalModemSelected(this.fLocalModemCheckBox.isSelected());
        this.model.setRemoteModemSelected(this.fRemoteModemCheckBox.isSelected());
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        this.model.setLocalModemSelected(this.fLocalModemCheckBox.isSelected());
        this.model.setRemoteModemSelected(this.fRemoteModemCheckBox.isSelected());
    }

    public String getHelpIdString() {
        return "extras.selectConfigModem";
    }

    public void refreshData() {
        this.setDefaultValue();
    }
}

